// orphanTest.c
// Shows what happens when a child is orphaned, i.e. when its parent dies.
// JBS

#include <stdlib.h>	   // exit
#include <stdio.h>	   // printf
#include <unistd.h>	   // getpid, getppid, sleep
#include <sys/types.h> // pid_t

int main() {

    pid_t parent_pid = getpid();
    printf("Parent id: %d\n", parent_pid);
    pid_t fork_pid = fork();
    if (fork_pid < 0) {
	perror("fork failed!");
	exit(1);
    }
    if (fork_pid > 0) {
        sleep(3);
        exit(0);
    } else {
        printf("I am the child (%d).  My parent is %d\n", getpid(), getppid());
        while (getppid() == parent_pid) sleep(1);
        printf("Now I (%d) am an orphan! (Woe is me!)  My parent is %d\n",
	       getpid(), getppid());
    }
}
